var GL2	 = require('../NGCore/Client/GL2').GL2;
var UI	 = require('../NGCore/Client/UI').UI;
var Util = require('./lib/Util').Util;

//----- 初期化処理
function initialize() {
	//-----
	var width  = UI.Window.getWidth();
	var height = UI.Window.getHeight();

	//-----
	var bg = Util.makePrimitive(0, 0, width, height, [1.0, 1.0, 1.0]);
	GL2.Root.addChild(bg);

	//-----
	var target = new GL2.TouchTarget();
	target.setSize([width, height]);
	GL2.Root.addChild(target);

	//-----
	var listener = new Core.MessageListener();
	listener.onTouch = function(touch) {
		var fp = new GL2.Sprite();
		fp.setImage("./Content/fingerprint.png", [80, 103], [0.5, 0.5]);
		fp.setPosition(touch.getPosition());
		GL2.Root.addChild(fp);
	};
	target.getTouchEmitter().addListener(listener, listener.onTouch);
}

//----- 起動時に呼ばれる
function main() {
	new UI.GLView({
		frame: [0, 0, UI.Window.getWidth(), UI.Window.getHeight()],
		onLoad: initialize
	}).setActive(true);
}
