var Core = require('../../NGCore/Client/Core').Core;
var GL2  = require('../../NGCore/Client/GL2').GL2;
var utils = require('../../DnLib/Dn/utils').utils;
var VFX =  require('../../DnLib/Dn/GL2/VFX').VFX;
var Ray = require('../lib/BattleUtil').Ray;
var Score = require('./Score');

//========================================================================================
exports.Enemy = Core.MessageListener.subclass({

	//--------------------------------------------------------------------------
	initialize: function(scene, parent, judgement) {

		this._scene = scene;

		//-----
		var size = [160, 160];
		var x = 480 * Math.random();
		this._velocity = -17;
		this._gravity = 0.5;
		var nextX = 480 * Math.random();
		this._vx = (nextX - x) / 60;
		this._judgement = judgement;

		//-----
		this._node = new GL2.Node();
		this._node.setPosition( x, 320 );

		//-----
		this._view = new GL2.Sprite();
		this._view.setPosition(-size[0] / 2, -size[1] / 2);
		this._view.setImage( "./Content/fish.png", size, [0.0, 0.0] );
		this._node.addChild(this._view);

		//----- Create touch target.
		this._target = new GL2.TouchTarget();
		this._target.setAnchor([0.5, 0.5]);
		this._target.setSize(size);
		this._node.addChild(this._target);

		//-----
		this._judgement.addTarget(this);

		//-----
		parent.addChild(this._node);

		//-----
		Core.UpdateEmitter.addListener( this, this.onUpdate );
	},
	
	//--------------------------------------------------------------------------
	destroy: function() {
		Core.UpdateEmitter.removeListener(this)
 		this._judgement.removeTarget(this);
		this._node.destroy();
	},
	
	//--------------------------------------------------------------------------
	onUpdate: function( delta ) {

		var pos = this._node.getPosition();

// 		if(pos.getY() < 160) return;

		this._node.setPosition(pos.getX() + this._vx, pos.getY() + this._velocity);

		if(pos.getY() > 580) {
			// messaging
			this._scene.onDamage();

			this.destroy();
		}

		this._velocity += this._gravity ;
	},

	getRect: function() {
		var pos = this._node.getPosition();
		return new Core.Rect([pos.getX()-60, pos.getY()-60], [120, 120])
	},

	handler: function() {
		Core.UpdateEmitter.removeListener(this)
 		this._judgement.removeTarget(this);

		var self = this;
		VFX.enchant(this._node)
			.blink(0.6, 0.1, [1.0, 0.0])
			.and(function(){
				new Score.ScorePopup(GL2.Root, self._node.getPosition(), 100);
				this.finish();
			}).end();

		// messaging
		this._scene.onDestroyedFish();
	}

});


//========================================================================================
exports.EnemyGenerator = Core.MessageListener.subclass({

	SPAWN_RATE: 10,
	SPAWN_NUM:  3,

	initialize: function(scene, parent, judgement, trajectory) {
		this._scene = scene;
		this._parent = parent;
		this._count = 0;
		this._judgement = judgement;
		this._trajectory = trajectory;
		Core.UpdateEmitter.addListener( this, this.onUpdate );
	},

	onUpdate: function() {
		if(this._count % this.SPAWN_RATE === 0) {
			//if(this._count === 0) {
			for (var i = 0; i < this.SPAWN_NUM; i++) {
				var enemy = new exports.Enemy(this._scene, this._parent, this._judgement);
				NgLogD("spawn 1");
			}
		}

		var rayList = [];
		var vlist = this._trajectory.getVertexList();
		for (var i = 0; i < vlist.length - 1; i++) {
			rayList.push(new Ray(vlist[i].x, vlist[i].y, vlist[i+1].x, vlist[i+1].y));
		}
		this._judgement.setTraj(rayList);
		this._judgement.update();
		this._count++;
	},

	destroy: function() {
		
	}
});
