var Core = require('../../NGCore/Client/Core').Core;
var Vector2D = require('../lib/BattleUtil').Vector2D;
var Ray = require('../lib/BattleUtil').Ray;
var segToSeg = require('../lib/BattleUtil').segToSeg;


exports.TrajectoryJudgement = Core.Class.subclass({

	initialize: function() {
		this._list = null;
		this._rayList = null;
		this._targetList = {};
		this._hanteizumi = null;
		this._index = 0;
		this._removeList = [];
		this.reset();
	},

	reset: function() {
		this._hanteizumi = {};
	},

	addTarget: function(target) {
		target._index = this._index++;
		this._targetList[target._index] = target;
	},

	removeTarget: function(target) {
		this._removeList.push(target);
	},

	setTraj: function(rayList) {
		this._rayList = rayList;
	},

	update: function() {

		this.reset();

		for (var i in this._targetList) {
			this._hoge(this._targetList[i], i);
		}

		for (var i = 0; i < this._removeList.length; i++) {
			var target = this._removeList[i];
			delete this._targetList[target._index];
		}

		this._removeList = [];
	},

	_hoge: function(t, i) {
		if (this._hanteizumi[i]) { return; }
		for (var j = 0; j < this._rayList.length; j++) {
			var r = this._rayList[j];
			if (this._lineKukei(r, t.getRect())) {
				if(t.handler) t.handler.apply(t);
				this._hanteizumi[i] = true;
				return;
			}
		}
	},

	_lineKukei: function(ray, rect) {
		return segToSeg(ray, new Ray(rect.getMinX(), rect.getMinY(), rect.getMinX(), rect.getMaxY())) ||
			segToSeg(ray, new Ray(rect.getMinX(), rect.getMaxY(), rect.getMaxX(), rect.getMaxY())) || // |_|
			segToSeg(ray, new Ray(rect.getMaxX(), rect.getMaxY(), rect.getMaxX(), rect.getMinY())) || //|=
			segToSeg(ray, new Ray(rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMinY())); // |-|
	}

});
