var Core = require('../../NGCore/Client/Core').Core;
var GL2  = require('../../NGCore/Client/GL2').GL2;
var utils = require('../../DnLib/Dn/utils').utils;


//========================================================================================
exports.ScoreBoard = Core.MessageListener.subclass({

	//--------------------------------------------------------------------------
	initialize: function(parent, pos) {

		//-----
		this._node = new GL2.Text("100 ten");
		this._node.setAnchor([0, 0]);
		this._node.setPosition(pos);
		this.update(0);

		//-----
		parent.addChild(this._node);
	},
	
	//--------------------------------------------------------------------------
	destroy: function() {
		this._node.destroy();
	},
	
	//--------------------------------------------------------------------------
	update: function( newScore ) {
		this._node.setText("SCORE " + newScore);
	}
});

//========================================================================================
exports.ScorePopup = Core.MessageListener.subclass({

	//--------------------------------------------------------------------------
	initialize: function(parent, pos, score) {

		this._vy = 0.1;
		this._spawn_at = +new Date();

		//-----
		this._node = new GL2.Text("100 pts");
		this._node.setPosition(pos);

		//-----
		parent.addChild(this._node);

		//-----
		Core.UpdateEmitter.addListener( this, this.onUpdate );
	},
	
	//--------------------------------------------------------------------------
	destroy: function() {
		Core.UpdateEmitter.removeListener(this)
		this._node.destroy();
	},
	
	//--------------------------------------------------------------------------
	onUpdate: function( delta ) {
		var pos = this._node.getPosition();

		this._node.setPosition(pos.getX(), pos.getY() - delta * this._vy);

		if(new Date() - this._spawn_at > 600) {
			this.destroy();
		}
	}
});
