var Core  = require('../../NGCore/Client/Core').Core;
var GL2   = require('../../NGCore/Client/GL2').GL2;
var Audio = require('../../NGCore/Client/Audio').Audio;
var GlobalTouchEmitter = require('../../DnLib/Dn/GL2/GlobalTouchEmitter').GlobalTouchEmitter;
var Scene = require('../../DnLib/Dn/Scene/SceneDirector').Scene;
var GameOverScene = require('../scene/GameOverScene').GameOverScene;
var BattleUtil = require('../lib/BattleUtil').BattleUtil;
var Ray = require('../lib/BattleUtil').Ray;
var TrajectoryJudgement = require('../lib/Judgement').TrajectoryJudgement;
var Trajectory = require('../entity/Trajectory').Trajectory;
var Enemy = require('../entity/Enemy').Enemy;
var Score = require('../entity/Score');
var Life = require('../entity/Life');
var EnemyGenerator = require('../entity/Enemy').EnemyGenerator;

var nj;
if (!nj) { var nj  = {}; }
if (!nj.battle) { nj.battle = {}; }

//========================================================================================
exports.MainScene = Scene.subclass({

	//--------------------------------------------------------------------------
	initialize: function()
	{
		this._node       = null;
		this._blind      = null;
		this._trajectory = null;
		this._enemyLayer = null;
		this._enemy      = null;
		this._judgement  = null;
		this._scoreBoard = null;
		this._lifeGauge  = null;
		this._generator  = null;
		this._score = 0;
		this._life = 3;
	},
	
	//--------------------------------------------------------------------------
	onEnter: function()
	{
		//----- create node
		this._node = new GL2.Node();
		
		//----- blind previous scene
		var width  = Core.Capabilities.getScreenHeight();
		var height = Core.Capabilities.getScreenWidth();

		this._blind = BattleUtil.makePrimitive(
			0, 0, width, height,
			[0.5, 0.4, 0.4], [0.2, 0.1, 0.1],
			[0.2, 0.1, 0.1], [0.0, 0.0, 0.2]
		);
		this._blind.setDepth( -1 );
		GL2.Root.addChild( this._blind );

		//----- create Layer
		this._enemyLayer = new GL2.Node();
		this._node.addChild(this._enemyLayer);

		//----- Trajectory of the Blade
		nj.battle.touchEmitter = new GlobalTouchEmitter();
		this._trajectory = new Trajectory( nj.battle.touchEmitter );
		this._node.addChild( this._trajectory.node );

		//-----
		this._judgement = new TrajectoryJudgement();
		//this._judgement.setTraj([new Ray(0, 160, 480, 160)]);

		//-----
		this._scoreBoard = new Score.ScoreBoard(this._node, new Core.Point(0, 0));

		//-----
		this._lifeGauge  = new Life.LifeGauge(this._node, new Core.Point(0, 24), 10);

		//-----
		this._generator = new EnemyGenerator(this, this._enemyLayer, this._judgement, this._trajectory);

		//-----
		GL2.Root.addChild( this._node );
	},
	
	//--------------------------------------------------------------------------
	onExit: function()
	{
		this._scoreBoard.destroy();
		this._lifeGauge.destroy();
		this._generator.destroy();
		this._blind.destroy();
		this._trajectory.destroy();

		this._enemyLayer.destroy();
		nj.battle.touchEmitter.destroy();
		this._node.destroy();
	},

	getValue: function() {
		return this._score;
	},

	onDestroyedFish: function() {
		this._score += 100;
		this._scoreBoard.update(this._score);
	},

	onDamage: function() {
		this._life -= 1;
		this._lifeGauge.update(this._life);
		if(this._life <= 0) {
			Dn.SceneDirector.replaceScene(new GameOverScene());
			this.onDamage = function() {};
		}
	}

});
