var Core    = require('../NGCore/Client/Core').Core;
var GL2     = require('../NGCore/Client/GL2').GL2;
var UI      = require('../NGCore/Client/UI').UI;
var Device  = require('../NGCore/Client/Device').Device;
var XHR     = require('../NGCore/Client/Network/XHR').XHR;
var LocalGameList = require('../NGCore/Client/Core/LocalGameList').LocalGameList;


function main() {
	// つぶやき取得
	Game.getTweet();

	// user初期化
	Game.userInit();

	// Orientation
	Device.OrientationEmitter.setInterfaceOrientation(
		Device.OrientationEmitter.Orientation.LandscapeLeft);

	// GLView初期化
	Game.glView = new UI.GLView({
		frame: [0, 0, UI.Window.outerHeight, UI.Window.outerWidth],
		onLoad: Game.glViewInit,
	});
	// GLViewは setActive で update のON/OFFが可能
	Game.glView.setActive(true);
	
	// UI初期化
	Game.uiViewInit();
}

var Game = Core.Class.singleton({
	glView  : {},
	uiView  : {},
	BG      : {},
	Monster : {},
	Hammer  : {},
	tweet   : [],
	tweeterUser: "DeNAPR",
	userConst: {
		hammerNum: 5,
		huntNum: 0,
	},
	user    : {},
	restart: function() {
		Game.destroy();

		Game.userInit();
		Game.glViewInit();
		Game.uiViewInit();
	},
	destroy: function() {
		Game.BG.destroy();	
		Game.Monster.destroy();
		Game.Hammer.destroy();	
		for (var key in Game.uiView) {
			Game.undrawUI(key);
		}
	},
	getTweet: function() {
		var url = 'http://twitter.com/statuses/user_timeline/';
		Game.request('GET', url + Game.tweeterUser + '.json', {
			success: function(request){
				var data = JSON.parse(request.responseText);
				for (var i=0,len=data.length;i<len;i++) {	
					if (data[i].text.length) {
						NgLogD(data[i].text);
						Game.tweet.push(data[i].text);
					}
				}
			}
		});
	},
	glViewInit: function() {	
		// 背景初期化
	       	Game.BG = new GL2.Sprite();
		Game.BG.setImage('Content/gl/chip_w.png',[
			UI.Window.outerHeight, UI.Window.outerWidth], [0,0]);	
		GL2.Root.addChild(Game.BG);
		
		// モンスター、ハンマー初期化
		Game.Monster = new Monster();
		Game.Hammer  = new Hammer();
	},
	uiViewInit: function() {
		Game.drawUI("reloadButton");
		Game.drawUI("hammerNumImage");
		Game.drawUI("huntNumImage");
		Game.drawUI("huntNumLabel");
		Game.getUI("huntNumLabel").setText(""+Game.user.huntNum);
	},
	userInit: function() {
		for (var key in Game.userConst) {
			Game.user[key] = Game.userConst[key];
		}
		NgLogD(JSON.stringify(Game.user));
	},
	make9FrameAnimation: function(path, size, fps) {
		_anim = new GL2.Animation();
		var fps = fps || 1000/9;
		var anch = [0.5, 0.5];
		_anim.pushFrame(new GL2.Animation.Frame(path, fps, size, anch, [0/3,0/3,1/3,1/3]));
		_anim.pushFrame(new GL2.Animation.Frame(path, fps, size, anch, [1/3,0/3,1/3,1/3]));
		_anim.pushFrame(new GL2.Animation.Frame(path, fps, size, anch, [2/3,0/3,1/3,1/3]));
		_anim.pushFrame(new GL2.Animation.Frame(path, fps, size, anch, [0/3,1/3,1/3,1/3]));
		_anim.pushFrame(new GL2.Animation.Frame(path, fps, size, anch, [1/3,1/3,1/3,1/3]));
		_anim.pushFrame(new GL2.Animation.Frame(path, fps, size, anch, [2/3,1/3,1/3,1/3]));
		_anim.pushFrame(new GL2.Animation.Frame(path, fps, size, anch, [0/3,2/3,1/3,1/3]));
		_anim.pushFrame(new GL2.Animation.Frame(path, fps, size, anch, [1/3,2/3,1/3,1/3]));
		_anim.pushFrame(new GL2.Animation.Frame(path, fps, size, anch, [2/3,2/3,1/3,1/3]));
		return _anim;
	},
	request: function(method, url, opts) {
		opts = opts || {};
		var default_opts = {
			success : function(){},
			error : function(){},
		};
		for (var key in default_opts) {
			opts[key] = opts[key] || default_opts[key];
		}
		var _request = new XHR();
		_request.onreadystatechange = function () {
			if (_request.readyState === 4) {
				if (_request.status === 200) {
					opts.success(_request);
				} else {
					NgLogD("Error:" + _request.error);
					NgLogD(JSON.stringify(_request));
					opts.error(_request);
				}
			}
			//NgLogD("onReadystatechange:" + _request.readyState);
		};
		_request.open(method, url);
		_request.send();
	},
	drawUI: function(func) {
		var views = Game[func]();
		if (views) {
			Game.uiView[func] = views;
			for (var key in views) {
				UI.Window.document.addChild(views[key]);
			}
		}
	},
	undrawUI: function(func) {
		var views = Game.uiView[func];
		if (views) {
			for (var key in views) {
				views[key].destroy();
			}
		}
		delete Game.uiView[func];
	},
	getUI: function(func) {
		var views = Game.uiView[func];
		// views が配列で要素が1つの時以外はviewsを返す
		if (typeof views == 'object' && views.length == 1) {
			return views[0];
		} else {
			return views;
		}
	},
	gameOver: function() {
		var views = [];
		var w = UI.Window.outerHeight;
		var h = UI.Window.outerWidth;

		var view = new UI.Label({
			frame: [(w - 200) / 2, (h - 50) / 2, 200, 50],
			backgroundColor : "88FFFFFF",
			text: "Game Over",
			textSize: 20,
			textGravity: [0.5, 0.5]
		});
		views.push(view);
		
		var view = new UI.Button({
			frame: [(w - 100) / 2, (h - 50) / 2 + 70, 100, 50],	
			backgroundColor: "88FFFFFF",
			normalText: " restart ",
			pressedText: "*restart*",
			textSize: 20,
			textGravity: [0.5, 0.5],
			touchable: true,
			onClick: function() {
				Game.restart();
			}
		});
		views.push(view);

		return views;
	},
	hammerNumImage: function() {
		var num = Game.user.hammerNum;
		var images = [];
		for (var i=0;i<num;i++) {
			var x = UI.Window.outerHeight - (i * 20) - 30;
			var image = new UI.Image({
				"frame": [x, 10, 20, 20],
				"normalImage" : "Content/ui/hammer.png"
			});
			images.push(image);
		}
		return images;
	},
	huntNumImage: function() {
		var image = new UI.Image({
			frame: [10, 10, 20, 20],
			normalImage : "Content/ui/monster.png"
		});
		return [image];
	},
	huntNumLabel: function() {
		var label = new UI.Label({
			frame: [40, 10, 60, 20],
			textGravity: [0, 0.5]
		});
		return [label];
	},
	reloadButton: function() {
		var y = UI.Window.outerWidth - 30;
		var button = new UI.Button({
			frame: [10, y, 80, 20],
			backgroundColor: "88FFFFFF",
			normalText: " Reload ",
			pressedText: "*Reload*",
			textSize: 12,
			textGravity: [0, 0.5],
			touchable: true,
			onClick: function() {
				LocalGameList.restartGame();
			}
		});
		return [button];
	},
});

var Hammer = Core.MessageListener.subclass({
	initialize: function() {
		this._anim = {};
		this._timerID = null;

		this.touchable = true;

		var path = "Content/gl/hammer.png";
		var size = [120, 120];
		this._anim['hammer'] = Game.make9FrameAnimation(path, size, 600/9);
		this._sprite = new GL2.Sprite();	
		this._sprite.setDepth(10);

		var path = "Content/gl/effect.png";
		var size = [120, 120];
		this._anim['lost'] = Game.make9FrameAnimation(path, size);
		this._anim['lost'].setLoopingEnabled(false);

		this._target = new GL2.TouchTarget();
		this._target.getTouchEmitter().addListener(this, this.onTouch);
		this._sprite.addChild(this._target);

		this.appear();
	},
	appear: function() {
		this.touchable = true;

		this._sprite.setAnimation(this._anim['hammer']);
		this._anim['hammer'].setLoopingEnabled(true);

		var anch = this._sprite.getAnimation().getFrame(0).getAnchor();
		var size = this._sprite.getAnimation().getFrame(0).getSize();

		var x = Math.floor(Math.random()*(UI.Window.outerHeight - size.getWidth()) + 1);
		var y = Math.floor(Math.random()*(UI.Window.outerWidth - size.getHeight()) + 1);
		this._sprite.setPosition(
			x + size.getWidth()  * anch.getX(),
			y + size.getHeight() * anch.getY()
		);

		this._target.setAnchor(anch);
		this._target.setSize(size);
		
		GL2.Root.addChild(this._sprite);	
	},
	warp: function() {
		this.touchable = false;

		GL2.Root.removeChild(this._sprite);	
		this.appear();
	},
	lost: function() {
		this.touchable = false;

		Game.user.hammerNum--;
		Game.undrawUI("hammerNumImage");
		Game.drawUI("hammerNumImage");
		if (Game.user.hammerNum == 0) {
			Game.drawUI("gameOver");
			this._anim['lost'].setLoopingEnabled(true);
			this._sprite.setAnimation(this._anim['lost']);
		} else {
			this._sprite.setAnimation(this._anim['lost']);
			this._sprite.getAnimationCompleteEmitter().removeListener(this);
			this._sprite.getAnimationCompleteEmitter().addListener(this, this.warp);
		}
	},
	attack: function() {	
		if (Game.Monster.attacked(this._sprite.getPosition())) {
			this.warp();

			Game.user.huntNum++;
			Game.getUI("huntNumLabel").setText(""+Game.user.huntNum);
		} else {
			this.lost();
		}
		Game.Monster.lockon = false;
	},
	onTouch: function(touch) {
		if (!this.touchable) return;

		switch(touch.getAction()) {
		case touch.Action.Start:	
			this.selected = true;
			
			// 選択中は静止画表示
			var f = this._sprite.getAnimation().getFrame(0);
			this._sprite.setImage(
				f.getImage(), f.getSize(), f.getAnchor(), f.getUVs()
			);

			// ずっと握ってると消滅する
			var that = this;
			this._timerID = setTimeout(function(){
				that.selected = false;
				that.lost();
			}, 600);

			return true;
		case touch.Action.Move:
			// 押しっぱなし対策
			if (!this.selected) return;
			
			this._sprite.setPosition(touch.getPosition());
			return true;
		case touch.Action.End:
			// 押しっぱなし対策
			if (!this.selected) return;

			this.touchable = false;
			this.selected  = false;

			if (this._timerID) {
				clearTimeout(this._timerID);
				this._timerID = null;
			}

			this._anim['hammer'].setLoopingEnabled(false);
			this._sprite.setAnimation(this._anim['hammer']);
			
			// ２重登録すると怒られるのでまずはremoveすることにする
			this._sprite.getAnimationCompleteEmitter().removeListener(this);
			this._sprite.getAnimationCompleteEmitter().addListener(this, this.attack);

			//lockon
			Game.Monster.lockon = true;
		}
	},
	destroy: function() {
		this._target.getTouchEmitter().removeListener(this);
		this._sprite.getAnimationCompleteEmitter().removeListener(this);
		if (this._timerID) {
			clearTimeout(this._timerID);
			this._timerID = null;
		}
		
		this._sprite.destroy();
		for (var key in this._amin) {
			this._amin[key].destroy();
		}
		this._target.destroy();	
	},
});

var Monster = Core.MessageListener.subclass({
	initialize: function() {
		this._anim = {};
		this._tweet = {};
		this._delta = 0;

		var path = "Content/gl/leopard.png";
		var size = [160, 120];
		this._anim['default'] = Game.make9FrameAnimation(path, size);

		var path = "Content/gl/effect.png";
		var size = [120, 120];
		this._anim['damage'] = Game.make9FrameAnimation(path, size);
		this._anim['damage'].setLoopingEnabled(false);

		this._sprite = new GL2.Sprite();
		this.appear();

		Core.UpdateEmitter.addListener(this, this.onUpdate);
	},
	warp: function() {	
		GL2.Root.removeChild(this._sprite);
		this.appear();
	},
	tweetWarp: function() {
		NgLogD("tweerWarp")
		this.tweet();
		this.warp();
	},
	appear: function() {
		this._sprite.setColor(1, 1, 1);
		this._sprite.setAnimation(this._anim['default']);
		
		var anch = this._sprite.getAnimation().getFrame(0).getAnchor();
		var size = this._sprite.getAnimation().getFrame(0).getSize();

		var x = Math.floor(Math.random()*(UI.Window.outerHeight - size.getWidth()) + 1);
		var y = Math.floor(Math.random()*(UI.Window.outerWidth - size.getHeight()) + 1);
		this._sprite.setPosition(
			x + size.getWidth()  * anch.getX(),
			y + size.getHeight() * anch.getY()
		);

		GL2.Root.addChild(this._sprite);
	},
	attacked: function(attack) {
		var x = this._sprite.getPosition().getX();
		var y = this._sprite.getPosition().getY();
		var attack_x = attack.getX();
		var attack_y = attack.getY();

		if (
			x - 50 < attack_x && attack_x < x + 50 &&
			y - 50 < attack_y && attack_y < y + 50
		) {
			this._sprite.getAnimationCompleteEmitter().removeListener(this);
			
			this._sprite.setColor(1, 0, 0);
			this._sprite.setAnimation(this._anim['damage']);
			NgLogD("damage");
			this._sprite.getAnimationCompleteEmitter().addListener(this, this.tweetWarp);	
			return true;
		} else {
			return false;
		}
	},
	tweet: function() {
		NgLogD("call:tweet");
		var i = Math.floor(Math.random() * Game.tweet.length + 1);
		var txt = Game.tweet[i] || '痛てぇな';
		var tweet = new GL2.Text(txt);
		NgLogD("|" + txt + "|");

		var x = this._sprite.getPosition().getX();
		var y = this._sprite.getPosition().getY();
		y = (y < 120) ? 120 : y;
		y = (y > UI.Window.outerWidth - 100) ? UI.Window.outerWidth - 100 : y;
		tweet.setPosition(x, y);
		tweet.setDepth(5);
		tweet.setVerticalAlign(GL2.Text.VerticalAlign.Top);
		tweet.setHorizontalAlign(GL2.Text.HorizontalAlign.Left);
		tweet.setColor(1, 0, 0);
		tweet.setFontSize(10);
		tweet.setSize(120,200);

		GL2.Root.addChild(tweet);
		this._tweet[Date.now()] = tweet;
	},
	onUpdate: function(delta) {
		this._delta += delta;
		for (var key in this._tweet) {
			var m = this._tweet[key];
			var p = m.getPosition();
			var y = p.getY() - delta/100;
			var a = m.getAlpha() * 0.99;
			if (a < 0.1) {
				delete this._tweet[key];
				m.destroy();
			} else {
				m.setPosition(p.getX(), y);
				m.setAlpha(a);
			}
		}
		if (this._delta > 800) {
			this._delta = 0;
			if (!this.lockon && Math.random() > 0.5) {
				this.warp();
			}
		}
	},
	destroy: function() {
		Core.UpdateEmitter.removeListener(this);
		this._sprite.getAnimationCompleteEmitter().removeListener(this);
		this._sprite.destroy();
		for (var key in this._amin) {
			this._amin[key].destroy();
		}
		for (var key in this._tweet) {
			this._tweet[key].destroy();
		}
	},
});

