var Core  = require('../../NGCore/Client/Core').Core;
var GL2   = require('../../NGCore/Client/GL2').GL2;
var Audio = require('../../NGCore/Client/Audio').Audio;
var SceneDirector = require('../../DnLib/Dn/Scene/SceneDirector').SceneDirector;
var Scene = require('../../DnLib/Dn/Scene/SceneDirector').Scene;
var BattleUtil = require('../lib/BattleUtil').BattleUtil;
var MainScene = require('../scene/MainScene').MainScene;

//========================================================================================
exports.TitleScene = Scene.subclass({

	//--------------------------------------------------------------------------
	initialize: function()
	{
		this._node      = null;
		this._bg        = null;
		this._titleText = null;
		this._target    = null;
	},
	
	//--------------------------------------------------------------------------
	onEnter: function()
	{
		//----- create node
		this._node = new GL2.Node();
		
		//----- blind previous scene
		var width  = Core.Capabilities.getScreenHeight();
		var height = Core.Capabilities.getScreenWidth();

		this._bg = BattleUtil.makePrimitive(
			0, 0, width, height,
			[0.5, 0.5, 0.5], [0.2, 0.2, 0.2],
			[0.2, 0.2, 0.2], [0.0, 0.0, 0.2]
		);
		this._bg.setDepth( -1 );
		this._node.addChild( this._bg );

		//----- create title text
		this._titleText = new GL2.Text("TAP TO START");
		this._titleText.setPosition([width/2, height/2]);
		this._node.addChild( this._titleText );

		//----- Create touch target.
		this._target = new GL2.TouchTarget();
		this._target.setSize([width, height]);
		var listener = new Core.MessageListener();
		listener.onTouch = function() {
			SceneDirector.replaceScene( new MainScene() );
		};
		this._target.getTouchEmitter().addListener(listener, listener.onTouch);
		this._node.addChild(this._target);

		//-----
		GL2.Root.addChild( this._node );
	},
	
	//--------------------------------------------------------------------------
	onExit: function()
	{
		this._target.destroy();
		this._target = null;
		this._titleText.destroy();
		delete this._titleText;
		this._bg.destroy();
		delete this._bg;
	}

});
