var Core  = require('../../NGCore/Client/Core').Core;
var Scene = require('../../DnLib/Dn/Scene/SceneDirector').Scene;
var BattleUtil = require('../lib/BattleUtil').BattleUtil;
var Vector2D = require('../lib/BattleUtil').Vector2D;
var Ray = require('../lib/BattleUtil').Ray;
var segToSeg = require('../lib/BattleUtil').segToSeg;
var TrajectoryJudgement = require('../lib/Judgement').TrajectoryJudgement;

//========================================================================================
exports.TestScene = Scene.subclass({

	//--------------------------------------------------------------------------
	initialize: function()
	{
		this._judgement = new TrajectoryJudgement();
		this._numPassed = 0;
		this._target1 = {
			getRect: function() {
				return new Core.Rect(0, 0, 100, 100);
			},
			handler: function() {
				//assert
				this._numPassed++;
			}.bind(this)
		};
	},
	
	//--------------------------------------------------------------------------
	onEnter: function()
	{
		this.test1();
		this.test2();
		this.test3();
	},

	test1: function() {
		NgLogD("@@@@@@@@@@@@@@@@@@@@@@@@@@test");
		var v = new Vector2D(10, -5);
		v.pp();
		v.sub(v).pp();
		// 	v.dot(v).pp();
		// 	v.cross(v).pp();
		//v.dot(v).cross(v).pp();
		
		// +
		var r1 = new Ray(0, 0, 0, 10);
		var r2 = new Ray(-5, 5, 5, 5);
		var r3 = new Ray(-5, 0, -5, 10);
		r1.start.pp();
		r1.end.pp();
		r2.start.pp();
		r2.end.pp();
		var res = segToSeg(r1, r2);
		var res2 = segToSeg(r1, r3);
		this.assert(res);
		this.assertFalse(res2);
	},

	test2: function() {
		NgLogD("@@@@@@@@@@@@@@@@@@@@@@@@@@test2");

		//------
		this._numPassed = 0;
		this._judgement.addTarget(this._target1);
		this._judgement.addTarget(this._target1);

		//------
		this._judgement.setTraj([new Ray(-5, 10, 10, 20)]);
		this._judgement.update();

		//NgLogD("numPaased=" + numPassed);
		this.assert(this._numPassed === 2, "numPassed = 2");
	},

	test3: function() {
		NgLogD("@@@@@@@@@@@@@@@@@@@@@@@@@@test3");

		//------
		this._numPassed = 0;
		this._judgement.addTarget(this._target1);

		//------
		this._judgement.setTraj([new Ray(-50, 50, 50, 150)]);
		this._judgement.update();

		this.assert(this._numPassed === 0, "expect numPassed = 0");
	},
	
	//--------------------------------------------------------------------------
	onExit: function()
	{
	},

	assert: function(a, msg) {
		msg = msg || "expect true.";
		if (!a) {
			throw [a, msg].join();
		} else {
			NgLogD("ok.");
		}
	},

	assertTrue: function(a) {
		this.assert(a);
	},

	assertFalse: function(a) {
		this.assert(!a);
	}
	
});
