var GL2 = require('../NGCore/Client/GL2').GL2;
var UI  = require('../NGCore/Client/UI').UI;
var Device = require('../NGCore/Client/Device').Device;
var Util = require('./lib/Util').Util;
var Trajectory = require('./entity/Trajectory').Trajectory;

//----- 初期化処理
function initialize() {
	//----- 画面の向きを横に
	Device.OrientationEmitter.setInterfaceOrientation(
		Device.OrientationEmitter.Orientation.LandscapeLeft);

	//-----
	var width  = UI.Window.getWidth();
	var height = UI.Window.getHeight();

	//-----
	var bg = Util.makePrimitive(0, 0, height, width, [0.0, 0.0, 0.0]);
	GL2.Root.addChild(bg);

	//-----
	var target = new GL2.TouchTarget();
	target.setSize([height, width]);
	GL2.Root.addChild(target);

	//----- 剣の軌跡
	var trajectory = new Trajectory(target.getTouchEmitter());
	bg.addChild(trajectory.getNode());
}

//----- 起動時に呼ばれる
function main() {
	new UI.GLView({
		frame: [0, 0, UI.Window.getWidth(), UI.Window.getHeight()],
		onLoad: initialize
	}).setActive(true);
}
