var Core = require('../../NGCore/Client/Core').Core;
var GL2  = require('../../NGCore/Client/GL2').GL2;


exports.Vector2D = Core.Vector.subclass({

	add: function(v) {
		return new exports.Vector2D(this._x + v._x, this._y +  v._y);
	},

	sub: function(v) {
		return new exports.Vector2D(this._x - v._x, this._y - v._y);
	},

	dot: function(v) {
		return this._x * v._x + this._y * v._y;
	},

	cross: function(v) {
		return this._x * v._y - this._y * v._x;
	},

	pp: function() {
		NgLogD(["x", this._x, "y", this._y].join());
	}
});

// 線分と線分の当たり判定
exports.segToSeg = function (a, b) {
    var v0 = a.end.sub(a.start),
	c0 = b.start.sub(a.start).cross(v0),
	c1 = b.end.sub(a.start).cross(v0),
	v1 = b.end.sub(b.start),
	c2 = a.start.sub(b.start).cross(v1),
	c3 = a.end.sub(b.start).cross(v1);
    return c0 * c1 < 0 && c2 * c3 < 0;
}

exports.Ray = Core.Class.subclass({
	initialize: function(x1, y1, x2, y2) {
		this.start = new exports.Vector2D(x1, y1);
		this.end   = new exports.Vector2D(x2, y2);
	}
});

//========================================================================================
exports.BattleUtil = Core.Class.singleton({
	
	//--------------------------------------------------------------------------
	traverse: function( obj, func, level ) {
		var level = level || 0;
		for (var i in obj) {
			func.apply( this, [i, obj[i], level] );
			if (typeof( obj[i] ) === "object" ) {
				this.traverse( obj[i], func, level+1 );
			}
		}
	},
	
	//--------------------------------------------------------------------------
	dump: function( obj, name ) {
		NgLogD( '--------------- traverse: ' + name );
		
		this.traverse( obj, function( key, val, level ) {
			var indent = '';
			var output = '';
			for (var i=0;  i<level;  i++) { indent += '    '; }
			output += indent + key + ': ';
			if (! (val + '').match(/\[object Object\]/)) {
				output += val;
			}
			NgLogD( output );
		}, 1);
	},
	
	// 足せば sec 秒で x が targetX になるような差分を返す
	//--------------------------------------------------------------------------
	toward: function( x, targetX, sec ) {
		return dn.Timekeeper.getDelta( (targetX - x), sec );
	},
	
	//--------------------------------------------------------------------------
	makeButton: function( x, y, image, pressedImage, size, anchor, listener, onTouchHandler ) {
	
		var b = new GL2.Sprite();
		nj.Utils.setSpriteImage(b,  image, size, anchor );
		b.setPosition( x, y );
		b.image = image;
		b.pressedImage = pressedImage;
		
		var target = new GL2.TouchTarget();
		target.setAnchor( [0, 0] );
		target.setSize( size[0], size[1] );
		nj.battle.touchEmitter.addListener(
			listener,
			target,
			//----- on touch
			function( touch ) {
				if (! this._hasPushed) { this._hasPushed = false; }
				switch (touch.getAction()) {
				case touch.Action.Start:
					nj.Utils.setSpriteImage(b,  pressedImage, size, anchor );
					this._hasPushed = true;
					break;
				case touch.Action.End:
					if (this._hasPushed) {
						nj.Utils.setSpriteImage(b,  image, size, anchor );
						onTouchHandler.apply( listener );
					}
					break;
				}
			},
			//----- on finger out
			function() {
				nj.Utils.setSpriteImage(b,  image, size, anchor );
			}
		);
		b.addChild( target );
		
		return b;
	},
	
	//--------------------------------------------------------------------------
	makePrimitive: function( x, y, w, h, color1, color2, color3, color4 ) {
		
		if (arguments.length <= 6) {
			color3 = color2 || color1;
			color4 = color2 || color1;
			color2 = color1;
		}
		
		var p = new GL2.Primitive();
		p.setType( GL2.Primitive.Type.TriangleStrip );
		
		p.pushVertex( new GL2.Primitive.Vertex([0, 0], [0, 0], color1) );
		p.pushVertex( new GL2.Primitive.Vertex([w, 0], [1, 0], color2) );
		p.pushVertex( new GL2.Primitive.Vertex([0, h], [0, 1], color3) );
		p.pushVertex( new GL2.Primitive.Vertex([w, h], [1, 1], color4) );
		
		p.setPosition( x, y );
		return p;
	},
	
	//--------------------------------------------------------------------------
	makeText: function( text, size, color ) {
		return new nj.battle.ShadowText( text, size, color );
	},
	
	//--------------------------------------------------------------------------
	makeBlind: function() {
		
		//----- linear scaling して余った部分を黒い帯で隠す
		//----- (とりあえずの応急処置)
		var width  = Core.Capabilities.getScreenHeight();
		var height = Core.Capabilities.getScreenWidth();
		
		var scale    = height / 320;
		var shortage = width - (480 * scale);
		
		var blind;
		if (shortage > 0) {
			blind = new GL2.Primitive();
			blind.setType( GL2.Primitive.Type.TriangleStrip );
			blind.pushVertex( new GL2.Primitive.Vertex([width - shortage,      0], [0, 0], [0,0,0]) );
			blind.pushVertex( new GL2.Primitive.Vertex([width           ,      0], [1, 0], [0,0,0]) );
			blind.pushVertex( new GL2.Primitive.Vertex([width - shortage, height], [0, 1], [0,0,0]) );
			blind.pushVertex( new GL2.Primitive.Vertex([width           , height], [1, 1], [0,0,0]) );
			blind.setDepth( 99999999 );
			GL2.Root.addChild( blind );
		}
		return blind;
	}
});
