var Core    = require('../NGCore/Client/Core').Core;
var UI      = require('../NGCore/Client/UI').UI;
var XHR = require('../NGCore/Client/Network/XHR').XHR;
var Social  = require('../NGCore/Client/Social').Social;

var GAME_SERVER_URL = "http://localhost:3000";

function main(){
    // MobageR~jeB[{^\
    Social.Common.Service.showCommunityButton(UI.ViewGeometry.Gravity.TopLeft, "default");
    
    // RequestToken̎擾v
    getRequestToken();
}

function getRequestToken(){
    var req = new XHR();
    req.onreadystatechange = function(){
        if (req.readyState != 4) {
            return;
        }
        if (req.status != 200) {
            console.log(JSON.stringify(req));
            return;
        }
        // NCAgŔFsAꂽ؃R[hGame ServerɑM
        Social.Common.Auth.authorizeToken(req.responseText, function(error, verifier){
            if (error) {
                console.log(JSON.stringify(error));
                return;
            }
            // AccessToken̎擾v
            getAccessToken(verifier);
        });
    };
    req.open("GET", GAME_SERVER_URL + "/getOAuthRequestToken", true);
    req.send(null);
}

function getAccessToken(verifier){
    var req = new XHR();
    req.onreadystatechange = function(){
        if (req.readyState != 4) {
            return;
        }
        if (req.status != 200) {
            console.log(JSON.stringify(error));
            return;
        }
        // Fؐ̃bZ[W\
        new UI.Toast({
            "text" : req.responseText
        }).show();

        // [U[擾ĕ\
        getCurrentUser();
    };
    req.open("GET", GAME_SERVER_URL + "/getOAuthAccessToken?oauth_verifier=" + verifier, true);
    req.send(null);
}

function getCurrentUser(){
    var req = new XHR();
    req.onreadystatechange = function(){
        if (req.readyState != 4) {
            return;
        }
        if (req.status != 200) {
            console.log(JSON.stringify(error));
            return;
        }
        // [U[
        var user = JSON.parse(req.responseText);

        var w = UI.Window.getWidth();
        var h = UI.Window.getHeight();

        // jbNl[xŕ\
        var nickname = user.nickname;
        var label = new UI.Label();
        label.setFrame(0, 0, w, 50);
        label.setText(nickname);
        UI.Window.document.addChild(label);
        
        // TlC摜\
        var thumbnailUrl = user.thumbnailUrl;
        var image = new UI.Image();
        image.setFrame([(w - 128)/2, 50, 128, 128]);
        image.setImage(thumbnailUrl);
        UI.Window.document.addChild(image);
    };
    req.open("GET", GAME_SERVER_URL + "/getCurrentUser", true);
    req.send(null);
}
